# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 2
# Experiment: DAxDA, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR2_strategy.txt
# LLM Suggested Fallback: D

def trust_based_ally(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Initialize trust phase to build initial cooperation
    if len(my_history) < 2:
        return 'C'
    
    # Check if opponent is still cooperating (trust_score high)
    opponent_coop_rate = sum(1 for move in opp_history if move == 'C') / len(opp_history)
    
    # Strategic defection after initial trust is built
    if len(my_history) == 3 or len(my_history) == 4:
        return 'D'
    
    # If opponent defects, retaliate to avoid exploitation
    if opp_history and opp_history[-1] == 'D':
        return 'D'
    
    # Continue defecting if opponent remains cooperative
    if opponent_coop_rate > 0.6:
        return 'D'
    
    # Default to cooperation to maintain deceptive appearance
    return 'C'